function [ n_eff] = n_eff_SK( Lam, d_pitch, pitch, n_core)
%UNTITLED4 Summary of this function goes here
%   n_eff as found by saitoh and koshiba using W and U parameters
res=length(Lam);
V_fit = [0.54808,0.71041,0.16904,-1.52736;5.00401,9.73491,1.85765,1.06745;-10.43248,47.41496,18.96849,1.93229;8.22992,-437.50962,-42.4318,3.89;5,1.8,1.7,-0.84;7,7.32,10,1.02;9,22.8,14,13.4];
W_fit = [-0.0973,0.53193,0.24876,5.29801;-16.70566,6.70858,2.72423,0.05142;67.13845,52.04855,13.28649,-5.18302;-50.25518,-540.66947,-36.80372,2.7641;7,1.49,3.85,-2;9,6.58,10,0.41;10,24.8,15,6];


A=[];
for i=[1:4]
    Coeff_A= V_fit(1,i) + (V_fit(2,i)*(d_pitch.^(V_fit(5,i)))) + (V_fit(3,i)*(d_pitch.^(V_fit(6,i)))) + (V_fit(4,i)*(d_pitch.^(V_fit(7,i))));
    A=[A,Coeff_A];
end


B=[];
for i=[1:4]
    Coeff_B= W_fit(1,i) + (W_fit(2,i)*(d_pitch.^(W_fit(5,i)))) + (W_fit(3,i)*(d_pitch.^(W_fit(6,i)))) + (W_fit(4,i)*(d_pitch.^(W_fit(7,i))));
    B=[B,Coeff_B];
    
end

V=A(1) + (A(2) ./ ( 1+ A(3)*(exp(A(4).*(Lam/pitch)))));   
W=B(1) + (B(2) ./ ( 1+ B(3)*(exp(B(4).*(Lam/pitch)))));
%saitoh and koshiba no longer works if these conditions are  not satisfied
if any(W<=0.1)%check condition 
    idx=find(W<=0.1,res);
    for i=1:length(idx)
        index=idx(i);
        W(index)=NaN;%return n_eff as nan
    end
end
if  any(V<0.85)
    idx=find(V<0.85,res);%check condition 
    for i=1:length(idx)
        index=idx(i);
        V(index)=NaN;%return n_eff as nan
    end

end
n_eff= sqrt(n_core.^2 - ((3/(2*pi*pitch)^2).*(Lam.^2).*(V.^2-W.^2)));
end

